/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class VWEditArrayFieldDialog
extends VWModalDialog {
    private static final int COL_INDEX = 0;
    private static final int COL_ELEMENT = 1;
    private static final int FIELD_TYPE_UNKNOWN = 0;
    private Frame m_parentFrame = null;
    private Object[] m_fieldArray = null;
    private Vector m_fieldVector = null;
    private String m_fieldname = null;
    private String m_typeString = null;
    private Object m_object = null;
    private int m_type = 0;
    private VWTable m_table = null;
    private ListSelectionListener m_tableListSelectionListener = null;
    private String[] m_columnHeader = null;
    private AbstractTableModel m_tableModel = null;
    private VWFieldsCellRenderer m_renderer = new VWFieldsCellRenderer();
    private VWFieldsCellEditor m_editor = null;
    private boolean m_bRuntimeData = true;
    private JLabel m_nameLabel = null;
    private JLabel m_nameUI = null;
    private JLabel m_typeLabel = null;
    private JLabel m_typeUI = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_addButton = null;
    private JButton m_insertButton = null;
    private JButton m_deleteButton = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private ActionListener m_upButtonActionListener = null;
    private ActionListener m_downButtonActionListener = null;
    private ActionListener m_addButtonActionListener = null;
    private ActionListener m_insertButtonActionListener = null;
    private ActionListener m_deleteButtonActionListener = null;
    private ActionListener m_okButtonActionListener = null;
    private ActionListener m_cancelButtonActionListener = null;
    private ActionListener m_closeButtonActionListener = null;
    private ActionListener m_helpButtonActionListener = null;
    int m_firstIndex = -1;
    int m_lastIndex = -1;
    private boolean m_bCanceled = true;
    private boolean m_bReadOnly = false;
    private Object m_sampleValue = null;

    public VWEditArrayFieldDialog(Frame parent, String fieldname, Object[] fields, int type) {
        super(parent);
        this.m_parentFrame = parent;
        this.m_fieldname = fieldname;
        this.m_type = type;
        this.initData(fields);
        this.setupLayout();
    }

    public VWEditArrayFieldDialog(Frame parent, String fieldname, Vector fields, int type) throws NullPointerException {
        super(parent);
        this.m_parentFrame = parent;
        this.m_fieldname = fieldname;
        if (fields == null) {
            throw new NullPointerException();
        }
        this.m_type = type;
        this.initData(fields);
        this.setupLayout();
    }

    public VWEditArrayFieldDialog(Frame parent, VWFieldDataForTable dataForTable, boolean readOnly, boolean bRuntimeData) throws NullPointerException {
        super(parent);
        this.m_parentFrame = parent;
        if (dataForTable == null) {
            throw new NullPointerException();
        }
        this.m_fieldname = dataForTable.getFieldName();
        this.m_type = dataForTable.getType();
        this.m_bReadOnly = readOnly;
        this.m_bRuntimeData = bRuntimeData;
        this.m_sampleValue = dataForTable.getSampleValue();
        this.initData(dataForTable.getValue());
        this.setupLayout();
    }

    public void addNotify() {
        FontMetrics fm;
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_nameLabel.setFont(boldFont);
            this.m_typeLabel.setFont(boldFont);
        }
        TableColumn tcIndex = this.m_table.getColumnModel().getColumn(0);
        int width = 60;
        Font tableFont = this.m_table.getFont();
        if (tableFont != null && (fm = this.getFontMetrics(tableFont)) != null) {
            int index = 99;
            int count = this.m_tableModel.getRowCount();
            if (index < count) {
                index = count;
            }
            width = fm.stringWidth(new Integer(index).toString());
            width += 10;
            tcIndex.setMaxWidth(fm.stringWidth(new Integer(index * 10).toString()) + 10);
        }
        tcIndex.setPreferredWidth(width);
        tcIndex.setWidth(width);
    }

    public Object[] getFieldArray() {
        return this.m_fieldArray;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    private void initColumnHeader() {
        if (this.m_columnHeader == null) {
            this.m_columnHeader = new String[2];
            this.m_columnHeader[0] = " ";
            this.m_columnHeader[1] = VWResource.s_elements;
        }
    }

    private void initData(Object fields) {
        if (fields == null) {
            this.m_fieldArray = new Object[0];
        } else if (fields instanceof Object[]) {
            this.m_fieldArray = (Object[])fields;
        } else if (fields instanceof Vector) {
            int j;
            int i;
            Vector v = (Vector)fields;
            Vector vector = null;
            int count = 0;
            for (i = 0; i < v.size(); ++i) {
                if (!(v.elementAt(i) instanceof Object[]) || count >= ((Object[])v.elementAt(i)).length) continue;
                count = ((Object[])v.elementAt(i)).length;
            }
            this.m_fieldArray = new Object[count];
            for (i = 0; i < v.size(); ++i) {
                if (!(v.elementAt(i) instanceof Object[])) continue;
                Object[] objArray = (Object[])v.elementAt(i);
                Object obj = null;
                for (j = 0; j < count; ++j) {
                    if (this.m_fieldArray[j] == null) {
                        this.m_fieldArray[j] = new Vector();
                    }
                    if (j < objArray.length) {
                        obj = objArray[j];
                        vector = (Vector)this.m_fieldArray[j];
                        vector.addElement(obj);
                        continue;
                    }
                    obj = null;
                }
            }
            for (i = 0; i < count; ++i) {
                if (this.m_fieldArray[i] == null || !(this.m_fieldArray[i] instanceof Vector) || (vector = (Vector)this.m_fieldArray[i]) == null) continue;
                Object obj0 = vector.elementAt(0);
                boolean bSame = true;
                for (j = 1; j < vector.size(); ++j) {
                    Object obj = vector.elementAt(j);
                    if (!(obj0 != null && obj == null || obj0 == null && obj != null) && (obj0 == null || obj0.equals(obj))) continue;
                    bSame = false;
                    break;
                }
                if (!bSame || v.size() != vector.size()) continue;
                this.m_fieldArray[i] = obj0;
            }
        }
        this.initData();
    }

    private void initData() {
        if (this.m_fieldVector != null) {
            this.m_fieldVector.removeAllElements();
        } else {
            this.m_fieldVector = new Vector();
        }
        for (int i = 0; i < this.m_fieldArray.length; ++i) {
            this.m_fieldVector.addElement(this.m_fieldArray[i]);
        }
        if (this.m_fieldVector.size() > 0) {
            Object obj = this.m_fieldVector.elementAt(0);
            if (obj instanceof Vector) {
                obj = ((Vector)obj).elementAt(0);
            }
            this.initFieldType(obj);
        } else {
            this.initFieldType(this.m_type);
        }
    }

    private void initFieldType(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof VWAttachment) {
            this.m_type = 32;
        } else if (obj instanceof Boolean) {
            this.m_type = 4;
        } else if (obj instanceof Double) {
            this.m_type = 8;
        } else if (obj instanceof Integer) {
            this.m_type = 1;
        } else if (obj instanceof String) {
            this.m_type = 2;
        } else if (obj instanceof Date) {
            this.m_type = 16;
        } else if (obj instanceof VWXMLData) {
            this.m_type = 128;
        } else if (obj instanceof VWGuid) {
            this.m_type = 512;
        }
        this.initFieldType(this.m_type);
    }

    private void initFieldType(int fieldType) {
        try {
            switch (fieldType) {
                case 32: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = new VWAttachment();
                    break;
                }
                case 4: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = true;
                    break;
                }
                case 8: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = new Double(1.0);
                    break;
                }
                case 1: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = new Integer(0);
                    break;
                }
                case 2: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = "";
                    break;
                }
                case 16: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = new Date();
                    break;
                }
                case 128: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    String xmlString = "";
                    if (this.m_sampleValue != null && this.m_sampleValue instanceof String) {
                        xmlString = (String)this.m_sampleValue;
                    }
                    this.m_object = new VWXMLData(xmlString, null, null);
                    break;
                }
                case 512: {
                    this.m_typeString = VWFieldType.getLocalizedString(fieldType);
                    this.m_object = new VWGuid();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupLayout() {
        try {
            this.initColumnHeader();
            this.m_nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
            VWAccessibilityHelper.setAccessibility(this.m_nameLabel, this, VWResource.s_name, VWResource.s_name);
            this.m_nameUI = new JLabel();
            if (this.m_fieldname != null) {
                this.m_nameUI.setText(this.m_fieldname);
                VWAccessibilityHelper.setAccessibility(this.m_nameUI, this, this.m_fieldname, this.m_fieldname);
            } else {
                this.m_nameLabel.setVisible(false);
                this.m_nameUI.setVisible(false);
            }
            this.m_typeLabel = new JLabel(VWResource.s_label.toString(VWResource.s_type));
            VWAccessibilityHelper.setAccessibility(this.m_typeLabel, this, VWResource.s_type, VWResource.s_type);
            this.m_typeUI = new JLabel(this.m_typeString);
            VWAccessibilityHelper.setAccessibility(this.m_typeUI, this, this.m_typeString, this.m_typeString);
            if (this.m_bReadOnly) {
                this.m_closeButton = new JButton(VWResource.s_close);
                this.m_helpButton = new JButton(VWResource.s_help);
                VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
                this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
                this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            } else {
                this.m_okButton = new JButton(VWResource.s_ok);
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_helpButton = new JButton(VWResource.s_help);
                VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
                this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
                this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
                this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            this.m_addButton = (JButton)VWImageLoader.createToolBarButton("new.gif", VWResource.s_add, false);
            this.m_addButton.setEnabled(!this.m_bReadOnly);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_insertButton = (JButton)VWImageLoader.createToolBarButton("insert.gif", VWResource.s_insert, false);
            this.m_insertButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_insertButton, this, VWResource.s_insert, VWResource.s_insert);
            this.m_insertButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_deleteButton = (JButton)VWImageLoader.createToolBarButton("delete.gif", VWResource.s_delete, false);
            this.m_deleteButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_deleteButton, this, VWResource.s_delete, VWResource.s_delete);
            this.m_deleteButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_upButton = (JButton)VWImageLoader.createToolBarButton("up.gif", VWResource.s_up, false);
            this.m_upButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_upButton, this, VWResource.s_up, VWResource.s_up);
            this.m_upButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_downButton = (JButton)VWImageLoader.createToolBarButton("down.gif", VWResource.s_down, false);
            this.m_downButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_downButton, this, VWResource.s_down, VWResource.s_down);
            this.m_downButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tableModel = new AbstractTableModel(){

                public int getRowCount() {
                    if (VWEditArrayFieldDialog.this.m_fieldVector != null) {
                        return VWEditArrayFieldDialog.this.m_fieldVector.size();
                    }
                    return 0;
                }

                public int getColumnCount() {
                    return 2;
                }

                public String getColumnName(int col) {
                    if (VWEditArrayFieldDialog.this.m_columnHeader != null && col < VWEditArrayFieldDialog.this.m_columnHeader.length) {
                        return VWEditArrayFieldDialog.this.m_columnHeader[col];
                    }
                    return null;
                }

                public boolean isCellEditable(int row, int col) {
                    return col == 1 && !VWEditArrayFieldDialog.this.m_bReadOnly;
                }

                public Object getValueAt(int row, int col) {
                    if (col >= this.getColumnCount()) {
                        return null;
                    }
                    if (row >= this.getRowCount()) {
                        return null;
                    }
                    if (col == 1) {
                        Object obj = VWEditArrayFieldDialog.this.m_fieldVector.elementAt(row);
                        return obj;
                    }
                    if (col == 0) {
                        return new Integer(row + 1);
                    }
                    return null;
                }

                public void setValueAt(Object value, int row, int col) {
                    if (col == 0) {
                        return;
                    }
                    VWEditArrayFieldDialog.this.m_fieldVector.setElementAt(value, row);
                    VWEditArrayFieldDialog.this.updateOkButtonState();
                }

                public Class getColumnClass(int col) {
                    if (col == 0) {
                        return Integer.class;
                    }
                    return Object.class;
                }
            };
            this.m_table = new VWTable(this.m_tableModel);
            VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.s_valueTable, VWResource.s_valueTable);
            this.m_table.setCellSelectionEnabled(true);
            this.m_table.setSelectionMode(1);
            Container container = this.getContentPane();
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension("495,335");
            if (dim == null) {
                dim = new Dimension(450, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            String title = null;
            title = this.m_bReadOnly ? VWResource.s_editArrayFieldReadOnly : VWResource.s_editArrayField;
            this.setTitle(title);
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new GridBagLayout());
            northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = -1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            northPanel.add((Component)this.m_nameLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            northPanel.add((Component)this.m_nameUI, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = -1;
            northPanel.add((Component)this.m_typeLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            northPanel.add((Component)this.m_typeUI, gbCons);
            JPanel eastPanel = new JPanel();
            eastPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 1;
            c.gridwidth = 0;
            c.gridheight = 1;
            eastPanel.add(Box.createVerticalStrut(4), c);
            c.gridy = -1;
            eastPanel.add((Component)this.m_addButton, c);
            eastPanel.add(Box.createVerticalStrut(4), c);
            eastPanel.add((Component)this.m_insertButton, c);
            eastPanel.add(Box.createVerticalStrut(4), c);
            eastPanel.add((Component)this.m_deleteButton, c);
            eastPanel.add(Box.createVerticalStrut(10), c);
            eastPanel.add((Component)this.m_upButton, c);
            eastPanel.add(Box.createVerticalStrut(4), c);
            eastPanel.add((Component)this.m_downButton, c);
            c.weighty = 1.0;
            eastPanel.add(Box.createVerticalStrut(4), c);
            eastPanel.setBorder(BorderFactory.createEmptyBorder(8, 6, 0, 0));
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new FlowLayout());
            if (this.m_bReadOnly) {
                southPanel.add(this.m_closeButton);
                southPanel.add(this.m_helpButton);
            } else {
                southPanel.add(this.m_okButton);
                southPanel.add(this.m_cancelButton);
                southPanel.add(this.m_helpButton);
            }
            eastPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(6, 6));
            mainPanel.add((Component)northPanel, "First");
            mainPanel.add((Component)new JScrollPane(this.m_table), "Center");
            mainPanel.add((Component)eastPanel, "After");
            mainPanel.add((Component)southPanel, "Last");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            container.setLayout(new BorderLayout());
            container.add((Component)mainPanel, "Center");
            this.m_addButton.addActionListener(this.m_addButtonActionListener);
            this.m_addButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWEditArrayFieldDialog.this.performAdd();
                }
            };
            this.m_addButton.addActionListener(this.m_addButtonActionListener);
            this.m_insertButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWEditArrayFieldDialog.this.performInsert();
                }
            };
            this.m_insertButton.addActionListener(this.m_insertButtonActionListener);
            this.m_deleteButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWEditArrayFieldDialog.this.performDelete();
                }
            };
            this.m_deleteButton.addActionListener(this.m_deleteButtonActionListener);
            this.m_upButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWEditArrayFieldDialog.this.performMoveUp();
                }
            };
            this.m_upButton.addActionListener(this.m_upButtonActionListener);
            this.m_downButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWEditArrayFieldDialog.this.performMoveDown();
                }
            };
            this.m_downButton.addActionListener(this.m_downButtonActionListener);
            if (this.m_bReadOnly) {
                this.m_closeButtonActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWEditArrayFieldDialog.this.m_bCanceled = true;
                        if (VWEditArrayFieldDialog.this.m_editor != null) {
                            VWEditArrayFieldDialog.this.m_editor.cancelCellEditing();
                        }
                        VWEditArrayFieldDialog.this.setVisible(false);
                    }
                };
                this.m_closeButton.addActionListener(this.m_closeButtonActionListener);
            } else {
                this.m_okButtonActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWEditArrayFieldDialog.this.m_bCanceled = false;
                        if (VWEditArrayFieldDialog.this.m_editor != null) {
                            VWEditArrayFieldDialog.this.m_editor.stopCellEditing();
                        }
                        VWEditArrayFieldDialog.this.updateFieldArray();
                        VWEditArrayFieldDialog.this.setVisible(false);
                    }
                };
                this.m_okButton.addActionListener(this.m_okButtonActionListener);
                this.m_cancelButtonActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWEditArrayFieldDialog.this.m_bCanceled = true;
                        if (VWEditArrayFieldDialog.this.m_editor != null) {
                            VWEditArrayFieldDialog.this.m_editor.cancelCellEditing();
                        }
                        VWEditArrayFieldDialog.this.setVisible(false);
                    }
                };
                this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
            }
            this.m_helpButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (VWEditArrayFieldDialog.this.m_editor != null) {
                        VWEditArrayFieldDialog.this.m_editor.stopCellEditing();
                    }
                    VWHelp.displayPage(VWHelp.Help_General + "bpfwd049.htm");
                }
            };
            this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
            this.m_tableListSelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    VWEditArrayFieldDialog.this.m_firstIndex = VWEditArrayFieldDialog.this.m_table.getSelectionModel().getMinSelectionIndex();
                    VWEditArrayFieldDialog.this.m_lastIndex = VWEditArrayFieldDialog.this.m_table.getSelectionModel().getMaxSelectionIndex();
                    if (VWEditArrayFieldDialog.this.m_firstIndex >= 0) {
                        VWEditArrayFieldDialog.this.m_upButton.setEnabled(!VWEditArrayFieldDialog.this.m_bReadOnly && VWEditArrayFieldDialog.this.m_firstIndex > 0);
                        VWEditArrayFieldDialog.this.m_downButton.setEnabled(!VWEditArrayFieldDialog.this.m_bReadOnly && VWEditArrayFieldDialog.this.m_lastIndex < VWEditArrayFieldDialog.this.m_fieldVector.size() - 1);
                        VWEditArrayFieldDialog.this.m_insertButton.setEnabled(!VWEditArrayFieldDialog.this.m_bReadOnly);
                        VWEditArrayFieldDialog.this.m_deleteButton.setEnabled(!VWEditArrayFieldDialog.this.m_bReadOnly);
                    } else {
                        VWEditArrayFieldDialog.this.m_upButton.setEnabled(false);
                        VWEditArrayFieldDialog.this.m_downButton.setEnabled(false);
                        VWEditArrayFieldDialog.this.m_insertButton.setEnabled(false);
                        VWEditArrayFieldDialog.this.m_deleteButton.setEnabled(false);
                    }
                    VWEditArrayFieldDialog.this.updateOkButtonState();
                }
            };
            this.m_table.getSelectionModel().addListSelectionListener(this.m_tableListSelectionListener);
            this.m_editor = new VWFieldsCellEditor(this.m_parentFrame, this.m_bRuntimeData){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    if (value == null) {
                        Component component = super.getTableCellEditorComponent(table, VWEditArrayFieldDialog.this.m_object, isSelected, row, column);
                        if (component instanceof JTextField) {
                            ((JTextField)component).setText("");
                        }
                        return component;
                    }
                    return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                }

                public void focusLost(FocusEvent e) {
                }
            };
            TableColumn tcElement = this.m_table.getColumnModel().getColumn(1);
            tcElement.setCellEditor(this.m_editor);
            tcElement.setCellRenderer(this.m_renderer);
            this.m_editor.setFieldType(this.m_object);
            if (this.m_tableModel.getRowCount() > 0) {
                this.m_table.clearSelection();
                this.m_table.setRowSelectionInterval(0, 0);
            }
            this.updateOkButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object createNewObject() {
        Object obj = null;
        switch (this.m_type) {
            case 32: {
                obj = new VWAttachment();
                break;
            }
            case 4: {
                obj = true;
                break;
            }
            case 8: {
                obj = new Double(0.0);
                break;
            }
            case 1: {
                obj = new Integer(0);
                break;
            }
            case 2: {
                obj = "";
                break;
            }
            case 16: {
                obj = new Date();
                break;
            }
            case 128: {
                try {
                    String xmlString = "";
                    if (this.m_sampleValue != null && this.m_sampleValue instanceof String) {
                        xmlString = (String)this.m_sampleValue;
                    }
                    obj = new VWXMLData(xmlString, null, null);
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
                break;
            }
            case 512: {
                try {
                    obj = new VWGuid();
                    break;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        return obj;
    }

    private void performAdd() {
        if (this.m_editor != null) {
            this.m_editor.stopCellEditing();
        }
        this.m_fieldVector.addElement(this.createNewObject());
        int index = this.m_tableModel.getRowCount() - 1;
        this.m_tableModel.fireTableRowsInserted(index, index);
        this.m_table.clearSelection();
        this.m_table.setRowSelectionInterval(index, index);
    }

    private void performInsert() {
        int index = this.m_firstIndex;
        if (this.m_editor != null) {
            this.m_editor.stopCellEditing();
        }
        if (index != -1) {
            this.m_fieldVector.insertElementAt(this.createNewObject(), index);
            this.m_tableModel.fireTableRowsInserted(index, index);
            this.m_table.clearSelection();
            this.m_table.setRowSelectionInterval(index, index);
        }
    }

    private void performDelete() {
        int index = this.m_firstIndex;
        if (this.m_editor != null) {
            this.m_editor.cancelCellEditing();
        }
        for (int i = this.m_lastIndex; i >= this.m_firstIndex; --i) {
            if (this.m_fieldVector.size() <= 0) continue;
            this.m_fieldVector.removeElementAt(i);
        }
        this.m_tableModel.fireTableRowsDeleted(this.m_firstIndex, this.m_lastIndex);
        this.m_table.clearSelection();
        int rowCount = this.m_table.getRowCount();
        if (rowCount > 0) {
            index = index < rowCount ? index : rowCount - 1;
            this.m_table.setRowSelectionInterval(index, index);
        }
    }

    private void performMoveUp() {
        if (this.m_editor != null) {
            this.m_editor.stopCellEditing();
        }
        if (this.m_firstIndex > 0) {
            Object element = this.m_fieldVector.elementAt(this.m_firstIndex - 1);
            this.m_fieldVector.removeElementAt(this.m_firstIndex - 1);
            this.m_fieldVector.insertElementAt(element, this.m_lastIndex);
            this.m_tableModel.fireTableRowsUpdated(this.m_firstIndex - 1, this.m_lastIndex);
            this.m_table.setRowSelectionInterval(this.m_firstIndex - 1, this.m_lastIndex - 1);
        }
    }

    private void performMoveDown() {
        if (this.m_editor != null) {
            this.m_editor.stopCellEditing();
        }
        if (this.m_lastIndex < this.m_fieldVector.size() - 1) {
            Object obj = this.m_fieldVector.elementAt(this.m_lastIndex + 1);
            this.m_fieldVector.removeElementAt(this.m_lastIndex + 1);
            this.m_fieldVector.insertElementAt(obj, this.m_firstIndex);
            this.m_tableModel.fireTableRowsUpdated(this.m_firstIndex, this.m_lastIndex + 1);
            this.m_table.setRowSelectionInterval(this.m_firstIndex + 1, this.m_lastIndex + 1);
        }
    }

    private void updateFieldArray() {
        if (this.m_editor != null) {
            this.m_editor.stopCellEditing();
        }
        this.m_fieldArray = null;
        if (this.m_fieldVector != null) {
            int length = this.m_fieldVector.size();
            switch (this.m_type) {
                case 32: {
                    this.m_fieldArray = new VWAttachment[length];
                    break;
                }
                case 4: {
                    this.m_fieldArray = new Boolean[length];
                    break;
                }
                case 8: {
                    this.m_fieldArray = new Double[length];
                    break;
                }
                case 1: {
                    this.m_fieldArray = new Integer[length];
                    break;
                }
                case 2: {
                    this.m_fieldArray = new String[length];
                    break;
                }
                case 16: {
                    this.m_fieldArray = new Date[length];
                    break;
                }
                case 128: {
                    this.m_fieldArray = new VWXMLData[length];
                    break;
                }
                case 512: {
                    this.m_fieldArray = new VWGuid[length];
                    break;
                }
                default: {
                    this.m_fieldArray = new Object[length];
                }
            }
            for (int i = 0; i < length; ++i) {
                this.m_fieldArray[i] = this.m_fieldVector.elementAt(i);
            }
        }
    }

    private void updateOkButtonState() {
        if (this.m_okButton != null) {
            boolean bEnable = true;
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                Object obj = this.m_tableModel.getValueAt(i, 1);
                if (obj != null && !(obj instanceof Vector)) continue;
                bEnable = false;
            }
            this.m_okButton.setEnabled(bEnable);
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_fieldArray = null;
        if (this.m_fieldVector != null) {
            this.m_fieldVector.removeAllElements();
            this.m_fieldVector = null;
        }
        this.m_fieldname = null;
        this.m_typeString = null;
        this.m_object = null;
        if (this.m_table != null) {
            this.m_table.getSelectionModel().removeListSelectionListener(this.m_tableListSelectionListener);
            TableColumn tcElement = this.m_table.getColumnModel().getColumn(1);
            tcElement.setCellEditor(null);
            tcElement.setCellRenderer(null);
            this.m_table.removeReferences();
            this.m_table = null;
        }
        this.m_tableListSelectionListener = null;
        if (this.m_columnHeader != null) {
            for (int i = 0; i < this.m_columnHeader.length; ++i) {
                this.m_columnHeader[i] = null;
            }
            this.m_columnHeader = null;
        }
        this.m_tableModel = null;
        this.m_renderer = null;
        this.m_editor = null;
        this.m_nameLabel = null;
        this.m_nameUI = null;
        this.m_typeLabel = null;
        this.m_typeUI = null;
        if (this.m_upButton != null) {
            this.m_upButton.removeActionListener(this.m_upButtonActionListener);
            this.m_upButton = null;
        }
        this.m_upButtonActionListener = null;
        if (this.m_downButton != null) {
            this.m_downButton.removeActionListener(this.m_downButtonActionListener);
            this.m_downButton = null;
        }
        this.m_downButtonActionListener = null;
        if (this.m_addButton != null) {
            this.m_addButton.removeActionListener(this.m_addButtonActionListener);
            this.m_addButton = null;
        }
        this.m_addButtonActionListener = null;
        if (this.m_insertButton != null) {
            this.m_insertButton.removeActionListener(this.m_insertButtonActionListener);
            this.m_insertButton = null;
        }
        this.m_insertButtonActionListener = null;
        if (this.m_deleteButton != null) {
            this.m_deleteButton.removeActionListener(this.m_deleteButtonActionListener);
            this.m_deleteButton = null;
        }
        this.m_deleteButtonActionListener = null;
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this.m_okButtonActionListener);
            this.m_okButton = null;
        }
        this.m_okButtonActionListener = null;
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButton = null;
        }
        this.m_cancelButtonActionListener = null;
        if (this.m_closeButton != null) {
            this.m_closeButton.removeActionListener(this.m_closeButtonActionListener);
            this.m_closeButton = null;
        }
        this.m_closeButtonActionListener = null;
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButton = null;
        }
        this.m_helpButtonActionListener = null;
        super.removeReferences();
    }
}

